import * as server from "@minecraft/server"
import * as ui from "@minecraft/server-ui"

console.warn('player/fonction.js is loaded')

const world = server.world

//return a singular player wich is define by the argument
export function getPlayer(playerNumber) {
    const allPlayers = world.getAllPlayers();
    if (allPlayers.length === 0) {
        return undefined;
    }

    return allPlayers[playerNumber];
}

//get the location of a singular player wich is define by the argument
export function getPlayerLocation(playerNumber) {
    const player = getPlayer(playerNumber);
    if (player === undefined) {
        return undefined;
    }
    return player.location;
}

//display the location of the player define by the argument
export function displayPlayerLocation(playerNumber) {
    const player = getPlayer(playerNumber);
    console.warn('X:' + player.location.x)
    console.warn('Y:' + player.location.y)
    console.warn('Z:' + player.location.z)
}

//prevent the player define by the argument to swim up
export function sink(playerNumber) {
    const player = getPlayer(playerNumber);
    const velocity = player.getVelocity()
    if (velocity.y > 0) {
        player.applyKnockback(0, 0, 0, -0.1);
    }
}

//make the player define by the argument bump into the air at a force define into the argument
export function bump(playerNumber, force) {
    const player = getPlayer(playerNumber);
    player.applyKnockback(0, 0, force, force);
}
